<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Structure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class StructureController extends Controller
{
    public function index()
    {
        $structures = Structure::ordered()->get();
        return view('admin.structures.index', compact('structures'));
    }

    public function create()
    {
        return view('admin.structures.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255',
            'position' => 'required|max:255',
            'photo' => 'nullable|image|max:2048',
        ]);

        $data = $request->all();

        if ($request->hasFile('photo')) {
            $data['photo'] = $request->file('photo')->store('structures', 'public');
        }

        Structure::create($data);

        return redirect()->route('admin.structures.index')->with('success', 'Struktur berhasil ditambahkan');
    }

    public function edit(Structure $structure)
    {
        return view('admin.structures.edit', compact('structure'));
    }

    public function update(Request $request, Structure $structure)
    {
        $request->validate([
            'name' => 'required|max:255',
            'position' => 'required|max:255',
            'photo' => 'nullable|image|max:2048',
        ]);

        $data = $request->all();

        if ($request->hasFile('photo')) {
            if ($structure->photo) {
                Storage::disk('public')->delete($structure->photo);
            }
            $data['photo'] = $request->file('photo')->store('structures', 'public');
        }

        $structure->update($data);

        return redirect()->route('admin.structures.index')->with('success', 'Struktur berhasil diperbarui');
    }

    public function destroy(Structure $structure)
    {
        if ($structure->photo) {
            Storage::disk('public')->delete($structure->photo);
        }

        $structure->delete();

        return redirect()->route('admin.structures.index')->with('success', 'Struktur berhasil dihapus');
    }
}