@extends('layouts.frontend')

@section('content')

{{-- ===================== --}}
{{-- HERO SLIDER FULL LAYAR --}}
{{-- ===================== --}}
@if($sliders->count() > 0)
<section class="relative w-screen h-screen overflow-hidden text-white">

    <div id="slider-container" class="relative w-full h-full">

        @foreach($sliders as $index => $slider)
        <div class="slider-item {{ $index === 0 ? 'block' : 'hidden' }} absolute inset-0">

            {{-- Background --}}
            @if($slider->image)
            <div class="absolute inset-0"
                style="
                    background-image: url('{{ asset('storage/' . $slider->image) }}');
                    background-size: cover;
                    background-position: center;
                    background-repeat: no-repeat;
                ">
            </div>
            @endif

            {{-- Content --}}
            <div class="relative z-10 flex flex-col items-center justify-center h-full text-center px-4">
                <img src="{{ asset('img/Logo1.jpeg') }}"
                    class="w-32 h-32 mb-6 rounded-full border-4 border-white shadow-lg"
                    onerror="this.style.display='none'">

                <h1 class="text-5xl md:text-6xl font-bold mb-4 drop-shadow-lg">
                    {{ $slider->title }}
                </h1>

                @if($slider->description)
                <p class="text-xl md:text-2xl max-w-3xl drop-shadow">
                    {{ $slider->description }}
                </p>
                @endif
            </div>

        </div>
        @endforeach

        {{-- Navigation --}}
        @if($sliders->count() > 1)
        <button onclick="prevSlide()"
            class="absolute left-6 top-1/2 -translate-y-1/2 z-20 bg-black/40 hover:bg-black/60 rounded-full p-3 text-2xl">
            ‹
        </button>

        <button onclick="nextSlide()"
            class="absolute right-6 top-1/2 -translate-y-1/2 z-20 bg-black/40 hover:bg-black/60 rounded-full p-3 text-2xl">
            ›
        </button>
        @endif

    </div>
</section>

@else
{{-- HERO DEFAULT --}}
<section class="relative w-screen h-screen overflow-hidden text-white"
    style="
        background-image: url('{{ asset('img/DPM.jpg') }}');
        background-size: cover;
        background-position: center;
    ">
    <div class="flex flex-col items-center justify-center h-full text-center px-4">
        <img src="{{ asset('img/Logo.jpg') }}"
            class="w-32 h-32 mb-6 rounded-full border-4 border-white shadow-lg">

        <h1 class="text-5xl font-bold mb-4 drop-shadow-lg">Selamat Datang di DPM</h1>
        <p class="text-xl">Politeknik Balekambang Jepara</p>
    </div>
</section>
@endif


{{-- ================= --}}
{{-- ABOUT SECTION --}}
{{-- ================= --}}
<section class="py-16 bg-white">
    <div class="container mx-auto px-4 grid md:grid-cols-2 gap-12 items-center">
        <div>
            <h2 class="text-4xl font-bold mb-6">Tentang DPM</h2>
            <p class="text-gray-600 mb-4">
                Dewan Perwakilan Mahasiswa (DPM) adalah lembaga legislatif mahasiswa
                yang memperjuangkan aspirasi mahasiswa.
            </p>
                  <a href="{{ route('about') }}"
   class="mt-auto inline-block bg-purple-600 text-white px-6 py-3 rounded-lg hover:bg-purple-700 transition">
    Baca Selengkapnya
</a>
        </div>
        <div class="h-96 rounded-xl shadow-xl"
            style="
                background-image: url('{{ asset('img/DPM.jpg') }}');
                background-size: cover;
                background-position: center;
            ">
        </div>
    </div>
</section>


{{-- ========================= --}}
{{-- STRUKTUR ORGANISASI --}}
{{-- ========================= --}}
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <h2 class="text-4xl font-bold text-center mb-12">Struktur Organisasi DPM</h2>
        
        <div class="max-w-6xl mx-auto">
            {{-- Wadin III --}}
            <div class="flex justify-center mb-8">
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-4 border-purple-600 w-64">
                    <h3 class="font-bold text-lg mb-1">Wadir III</h3>
                    <p class="text-sm text-gray-600">Bidang Kemahasiswaan</p>
                </div>
            </div>

            {{-- Arrow Down --}}
            <div class="flex justify-center mb-8">
                <div class="w-1 h-12 bg-gray-400"></div>
            </div>

            {{-- Ketua DPM --}}
            <div class="flex justify-center mb-8">
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-4 border-purple-600 w-64">
                    <h3 class="font-bold text-lg">Ketua DPM</h3>
                </div>
            </div>

            {{-- Arrow Down & Split --}}
            <div class="flex justify-center mb-8">
                <div class="relative w-full max-w-4xl">
                    <div class="absolute left-1/2 transform -translate-x-1/2 w-1 h-12 bg-gray-400"></div>
                    <div class="absolute top-12 left-0 right-0 h-1 bg-gray-400"></div>
                    <div class="absolute top-12 left-1/4 w-1 h-12 bg-gray-400"></div>
                    <div class="absolute top-12 right-1/4 w-1 h-12 bg-gray-400"></div>
                </div>
            </div>

            {{-- Wakil Ketua, Sekretaris, Bendahara --}}
           <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-12 mt-12 relative top-8">

                <!-- <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-purple-400">
                    <h3 class="font-bold text-lg">Wakil Ketua DPM</h3>
                </div> -->
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-purple-400">
                    <h3 class="font-bold text-lg">Sekretaris</h3>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-purple-400">
                    <h3 class="font-bold text-lg">Bendahara</h3>
                </div>
            </div>

            {{-- Arrow Down from middle --}}
            <div class="flex justify-center mb-8">
                <div class="w-1 h-12 bg-gray-400"></div>
            </div>

            {{-- Three Commissions - Ketua --}}
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-4">
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-blue-400">
                    <h3 class="font-bold text-lg mb-2">Ketua Komisi I</h3>
                    <p class="text-sm text-gray-600">Badan Pengawasan</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-green-400">
                    <h3 class="font-bold text-lg mb-2">Ketua Komisi II</h3>
                    <p class="text-sm text-gray-600">Hukum dan Aspirasi</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-orange-400">
                    <h3 class="font-bold text-lg mb-2">Ketua Komisi III</h3>
                    <p class="text-sm text-gray-600">Penjaringan Pengembangan</p>
                </div>
            </div>

            {{-- Three Commissions - Anggota --}}
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-blue-300">
                    <h3 class="font-bold text-base mb-2">Anggota Komisi I</h3>
                    <p class="text-sm text-gray-600">Badan Pengawasan</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-green-300">
                    <h3 class="font-bold text-base mb-2">Anggota Komisi II</h3>
                    <p class="text-sm text-gray-600">Hukum dan Aspirasi</p>
                </div>
                <div class="bg-white p-6 rounded-lg shadow-lg text-center border-2 border-orange-300">
                    <h3 class="font-bold text-base mb-2">Anggota Komisi III</h3>
                    <p class="text-sm text-gray-600">Penjaringan Pengembangan</p>
                </div>
                <!-- <a href="{{ route('structure') }}"
                class="flex justify-center items-center inline-block bg-purple-600 text-white px-6 py-3 rounded-lg hover:bg-purple-700 transition">
                Selengkapnya
            </a> -->
            </div>
        </div>
    </div>
    <div class="flex flex-col items-center justify-center text-center mt-12">
    <!-- <p class="text-lg font-semibold mb-4">
        Lihat struktur organisasi DPM secara lengkap
    </p> -->
    <a href="{{ route('structure') }}"
       class="inline-block bg-purple-600 text-white px-6 py-3 rounded-lg hover:bg-purple-700 transition">
        Selengkapnya
    </a>
</div>

</section>
{{-- ========================= --}}
{{-- PRODUK HUKUM --}}
{{-- ========================= --}}
<section  class="py-16 bg-white"
>

    <div class="container mx-auto px-4">

        {{-- Judul --}}
        <div class="text-center mb-14 sm:mb-16">
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold tracking-wide">
                PRODUK HUKUM
            </h2>
            <div class="w-20 sm:w-24 h-1 bg-white mx-auto mt-5"></div>
        </div>

        {{-- Grid Card --}}
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 sm:gap-8">

            {{-- CARD --}}
            @php
                $produkHukum = [
                    [
                        'kode' => 'PDKM',
                        'deskripsi' => 'PDKM (Peraturan Dasar Keluarga Mahasiswa) merupakan konstitusi tertinggi yang mengatur struktur dasar organisasi, asas, tujuan, kelembagaan, dan sistem pemerintahan mahasiswa secara menyeluruh.'
                    ],
                    [
                        'kode' => 'GBHKMP',
                        'deskripsi' => 'GBHKMP (Garis-Garis Besar Haluan Keluarga Mahasiswa Politeknik) merupakan pedoman arah kebijakan KM Politeknik per periode yang memuat visi-misi, proyeksi masa depan, dan strategi pengembangan organisasi.'
                    ],
                    [
                        'kode' => 'PKM',
                        'deskripsi' => 'PKM (Peraturan Keluarga Mahasiswa) merupakan peraturan teknis yang mengatur mekanisme operasional KM Politeknik dan menjabarkan PDKM serta GBHKMP.'
                    ],
                    [
                        'kode' => 'PDPM',
                        'deskripsi' => 'PDPM (Peraturan Dewan Permusyawaratan Mahasiswa) merupakan peraturan internal DPM yang mengatur tata tertib, mekanisme kerja, persidangan, dan teknis operasional.'
                    ]
                ];
            @endphp

            @foreach($produkHukum as $item)
            <div class="shadow-lg border border-white/60 rounded-xl
                        p-5 sm:p-6 lg:p-8
                        text-center bg-white/5 backdrop-blur-sm
                        flex flex-col">

                <h3 class="text-xl sm:text-2xl font-bold mb-4">
                    {{ $item['kode'] }}
                </h3>

                <p class="text-sm sm:text-base leading-relaxed
                          mb-6 sm:mb-8
                          line-clamp-5 sm:line-clamp-none">
                    {{ $item['deskripsi'] }}
                </p>

              <a href="#"
   class="mt-auto inline-block bg-purple-600 text-white px-6 py-3 rounded-lg hover:bg-purple-700 transition">
    Baca Selengkapnya
</a>

            </div>
            @endforeach

        </div>
    </div>
</section>


{{-- ================= --}}
{{-- PROGRAM SECTION --}}
{{-- ================= --}}
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">

        <!-- Judul -->
        <h2 class="text-4xl font-extrabold text-center mb-4 text-gray-800">
            Program Kerja
        </h2>
        <p class="text-center text-gray-500 mb-14">
            Daftar rencana dan kegiatan yang akan dijalankan
        </p>

        @if($programs->count() > 0)
        <div class="grid sm:grid-cols-2 md:grid-cols-3 gap-8">
            @foreach($programs as $program)
            <div class="group bg-white p-6 rounded-2xl shadow-md hover:shadow-xl transition duration-300">

                <!-- Header Icon + Badge -->
                <div class="flex items-center justify-between mb-5">
                    <!-- Icon -->
                    <div class="w-14 h-14 flex items-center justify-center rounded-xl bg-purple-100 text-purple-600 group-hover:bg-purple-600 group-hover:text-white transition">
                        <i class="fas fa-tasks text-2xl"></i>
                    </div>

                    <!-- Badge Status -->
                    @php
                        $statusColor = [
                            'perencanaan' => 'bg-yellow-100 text-yellow-700',
                            'berjalan'    => 'bg-blue-100 text-blue-700',
                            'selesai'     => 'bg-green-100 text-green-700',
                        ];
                    @endphp

                    <span class="px-3 py-1 text-xs font-semibold rounded-full 
                        {{ $statusColor[$program->status] ?? 'bg-gray-100 text-gray-600' }}">
                        {{ ucfirst($program->status) }}
                    </span>
                </div>

                <!-- Judul -->
                <h3 class="text-xl font-bold mb-3 text-gray-800">
                    {{ $program->name }}
                </h3>

                <!-- Deskripsi -->
                <p class="text-gray-600 mb-4">
                    {{ Str::limit($program->description, 110) }}
                </p>

                <!-- Link -->
                <!-- <span class="inline-flex items-center text-sm font-semibold text-purple-600">
                    Selengkapnya
                    <i class="fas fa-arrow-right ml-2"></i>
                </span> -->
            </div>
            @endforeach
        </div>

        @else
        <!-- EMPTY STATE -->
        <div class="flex flex-col items-center justify-center text-center py-20">
            <div class="w-24 h-24 flex items-center justify-center rounded-full bg-purple-100 text-purple-600 mb-6">
                <i class="fas fa-hourglass-half text-4xl"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-800 mb-3">
                Program Kerja Akan Segera Tersedia
            </h3>
            <p class="text-gray-500 max-w-md">
                Saat ini belum ada program kerja yang dipublikasikan.
            </p>
        </div>
        @endif

    </div>
</section>




{{-- ================= --}}
{{-- NEWS SECTION --}}
{{-- ================= --}}
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <h2 class="text-4xl font-bold text-center mb-12">Berita Terbaru</h2>

        <div class="grid md:grid-cols-3 gap-8">
            @foreach($news as $item)
            <a href="{{ route('news.detail', $item->slug) }}"
                class="block bg-white rounded-xl shadow-lg overflow-hidden">
                <img src="{{ asset('storage/' . $item->image) }}"
                    class="w-full h-48 object-cover">
                <div class="p-6">
                    <h3 class="text-xl font-bold">{{ $item->title }}</h3>
                </div>
            </a>
            @endforeach
        </div>
    </div>
</section>


{{-- ================= --}}
{{-- CTA SECTION --}}
{{-- ================= --}}
<section class="py-20 text-white"
    style="
        background-image: url('{{ asset('img/DPM.jpg') }}');
        background-size: cover;
        background-position: center;
        background-color: rgba(0, 0, 0, 0.6);
        background-blend-mode: overlay;
    ">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl font-bold mb-6">Sampaikan Aspirasimu</h2>
        <a href="{{ route('aspiration') }}"
            class="inline-block bg-white text-black px-8 py-4 rounded-lg font-semibold">
            Kirim Aspirasi
        </a>
    </div>
</section>


{{-- ================= --}}
{{-- SLIDER SCRIPT --}}
{{-- ================= --}}
@if($sliders->count() > 1)
<script>
    let currentSlide = 0;
    const slides = document.querySelectorAll('.slider-item');

    function showSlide(index) {
        slides.forEach(slide => slide.classList.add('hidden'));
        slides[index].classList.remove('hidden');
    }

    function nextSlide() {
        currentSlide = (currentSlide + 1) % slides.length;
        showSlide(currentSlide);
    }

    function prevSlide() {
        currentSlide = (currentSlide - 1 + slides.length) % slides.length;
        showSlide(currentSlide);
    }

    setInterval(nextSlide, 5000);
</script>
@endif


{{-- ================= --}}
{{-- GLOBAL STYLE --}}
{{-- ================= --}}
<style>
    html, body {
        margin: 0;
        padding: 0;
        width: 100%;
        overflow-x: hidden;
    }
</style>

@endsection