<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Dashboard') - Admin DPM</title>

    <!-- TAILWIND -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="shortcut icon" href="{{ asset('img/Logo.png') }}">

    <!-- SIDEBAR -->
    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('-translate-x-full');
            document.getElementById('overlay').classList.toggle('hidden');
        }
    </script>

    <!-- NOTIFICATION -->
    <script>
        function toggleNotif() {
            document.getElementById('notifDropdown').classList.toggle('hidden');
        }
    </script>

    <!-- PROFILE -->
    <script>
        function toggleProfile() {
            document.getElementById('profileDropdown').classList.toggle('hidden');
        }

        document.addEventListener('click', function (e) {
            const profileBtn = e.target.closest('[onclick="toggleProfile()"]');
            const profileDropdown = document.getElementById('profileDropdown');
            const notifBtn = e.target.closest('[onclick="toggleNotif()"]');
            const notifDropdown = document.getElementById('notifDropdown');

            if (!profileBtn && profileDropdown && !profileDropdown.contains(e.target)) {
                profileDropdown.classList.add('hidden');
            }

            if (!notifBtn && notifDropdown && !notifDropdown.contains(e.target)) {
                notifDropdown.classList.add('hidden');
            }
        });
    </script>
</head>

<body class="bg-[#F5F7FB] text-[#111827] overflow-x-hidden">
    <div class="flex min-h-screen">

        <!-- SIDEBAR -->
        <aside id="sidebar" class="fixed lg:static inset-y-0 left-0 z-50
               w-[260px] bg-white border-r border-[#E6EAF2]
               transform -translate-x-full lg:translate-x-0
               transition-transform duration-300 ease-in-out">

            <!-- LOGO -->
            <div class="px-6 py-6 border-b border-[#E6EAF2]">
                <div class="flex items-center gap-3">
                    <img src="{{ asset('img/Logo.png') }}" class="w-8 h-8">
                    <span class="text-lg font-semibold">DPM Polibang</span>
                </div>
            </div>

            @php
                function auroraActive($route)
                {
                    return request()->routeIs($route)
                        ? 'bg-[#E8F0FE] text-[#3B82F6] font-semibold'
                        : 'text-[#6B7280] hover:bg-[#F1F5FF]';
                }
            @endphp

            <!-- MENU -->
            <nav class="px-4 py-6 space-y-1 text-sm">
                <p class="px-3 mb-2 text-xs font-semibold text-[#9CA3AF]">HOMEPAGE</p>

                <a href="{{ route('admin.dashboard') }}" onclick="toggleSidebar()"
                    class="flex items-center gap-3 px-4 py-[10px] rounded-xl {{ auroraActive('admin.dashboard') }}">
                    <i class="fa-solid fa-chart-simple"></i> Dashboard
                </a>

                <a href="{{ route('admin.sliders.index') }}" onclick="toggleSidebar()"
                    class="flex items-center gap-3 px-4 py-[10px] rounded-xl {{ auroraActive('admin.sliders.*') }}">
                    <i class="fa-regular fa-images"></i> Slider
                </a>

                <a href="{{ route('admin.news.index') }}" onclick="toggleSidebar()"
                    class="flex items-center gap-3 px-4 py-[10px] rounded-xl {{ auroraActive('admin.news.*') }}">
                    <i class="fa-regular fa-newspaper"></i> Berita
                </a>

                <a href="{{ route('admin.programs.index') }}" onclick="toggleSidebar()"
                    class="flex items-center gap-3 px-4 py-[10px] rounded-xl {{ auroraActive('admin.programs.*') }}">
                    <i class="fa-solid fa-list-check"></i> Program Kerja
                </a>

                <a href="{{ route('admin.structures.index') }}" onclick="toggleSidebar()"
                    class="flex items-center gap-3 px-4 py-[10px] rounded-xl {{ auroraActive('admin.structures.*') }}">
                    <i class="fa-solid fa-sitemap"></i> Struktur
                </a>

                <a href="{{ route('admin.documents.index') }}" onclick="toggleSidebar()"
                    class="flex items-center gap-3 px-4 py-[10px] rounded-xl {{ auroraActive('admin.documents.*') }}">
                    <i class="fa-regular fa-file-lines"></i> Dokumen
                </a>

                <a href="{{ route('admin.aspirations.index') }}" onclick="toggleSidebar()"
                    class="flex items-center gap-3 px-4 py-[10px] rounded-xl {{ auroraActive('admin.aspirations.*') }}">
                    <i class="fa-regular fa-comments"></i> Aspirasi
                </a>
            </nav>
        </aside>

        <!-- OVERLAY -->
        <div id="overlay" onclick="toggleSidebar()" class="fixed inset-0 bg-black/30 z-40 hidden lg:hidden"></div>

        <!-- MAIN -->
        <div class="flex-1 flex flex-col">

            <!-- TOPBAR -->
            <header class="bg-white border-b border-[#E6EAF2]
                       px-4 sm:px-6 md:px-8 py-3
                       flex items-center">

                <!-- LEFT -->
                <div class="flex items-center gap-4 flex-1">
                    <button onclick="toggleSidebar()" class="lg:hidden text-xl text-[#6B7280]">
                        <i class="fa-solid fa-bars"></i>
                    </button>

                    <div class="relative w-[200px] sm:w-[280px] md:w-[420px]">
                        <input type="text" placeholder="Search" class="w-full h-10 pl-11 pr-4 rounded-full
                               bg-[#F5F7FB] text-sm focus:outline-none">
                        <i class="fa fa-search absolute left-4 top-[11px] text-[#9CA3AF]"></i>
                    </div>
                </div>

                <!-- RIGHT -->
                <div class="flex items-center gap-5">

                    <!-- NOTIFICATION -->
                    <div class="relative">
                        <button onclick="toggleNotif()" class="relative text-[#9CA3AF] text-xl">
                            <i class="fa-regular fa-bell"></i>

                            @if(Auth::user()->unreadNotifications->count())
                                <span class="absolute -top-1 -right-1 bg-red-500 text-white text-[10px]
                                             w-5 h-5 flex items-center justify-center rounded-full">
                                    {{ Auth::user()->unreadNotifications->count() }}
                                </span>
                            @endif
                        </button>

                        <div id="notifDropdown" class="hidden absolute right-0 mt-3 w-80 bg-white
                               rounded-xl shadow-lg border z-50">

                            <div class="px-4 py-3 border-b font-semibold text-sm">
                                Notifikasi Aspirasi
                            </div>

                            <div class="max-h-[300px] overflow-y-auto">
                                @forelse(Auth::user()->notifications as $notif)
                                    <a href="{{ route('admin.aspirations.index') }}" class="block px-4 py-3 text-sm hover:bg-gray-50
                                       {{ $notif->read_at ? 'text-gray-500' : 'font-semibold' }}">
                                        <p>{{ $notif->data['title'] }}</p>
                                        <p class="text-xs text-gray-400">
                                            {{ $notif->created_at->diffForHumans() }}
                                        </p>
                                    </a>
                                @empty
                                    <p class="px-4 py-6 text-sm text-gray-400 text-center">
                                        Tidak ada notifikasi
                                    </p>
                                @endforelse
                            </div>

                            <div class="border-t px-4 py-2 text-center">
                                <a href="{{ route('notifications.read') }}" class="text-xs text-blue-600">
                                    Tandai semua sudah dibaca
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- PROFILE -->
                    <div class="relative">
                        <button onclick="toggleProfile()" class="flex items-center gap-2 px-2 py-1 rounded-lg
                               hover:bg-gray-100">

                            <div class="w-9 h-9 rounded-full bg-[#3B82F6] text-white
                                    flex items-center justify-center">
                                {{ strtoupper(substr(Auth::user()->name, 0, 1)) }}
                            </div>

                            <span class="hidden md:block text-sm font-medium">
                                {{ Auth::user()->name }}
                            </span>
                        </button>

                        <div id="profileDropdown" class="hidden absolute right-0 mt-3 w-56 bg-white
                               rounded-xl shadow-lg border z-50">

                            <div class="px-4 py-3 border-b">
                                <p class="text-sm font-semibold">
                                    {{ Auth::user()->name }}
                                </p>
                                <p class="text-xs text-gray-500">
                                    {{ Auth::user()->email }}
                                </p>
                            </div>

                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="w-full text-left px-4 py-3 text-sm
                                       text-red-600 hover:bg-red-50 rounded-b-xl">
                                    <i class="fa-solid fa-right-from-bracket mr-2"></i>
                                    Logout
                                </button>
                            </form>
                        </div>
                    </div>

                </div>
            </header>

            <!-- CONTENT -->
            <main class="p-4 sm:p-6 md:p-8 flex-1">
                <div class="max-w-7xl mx-auto px-2 sm:px-0">
                    @if(session('success'))
                        <div class="mb-6 px-5 py-3 bg-[#E8F0FE]
                                    text-[#3B82F6] rounded-xl text-sm">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="mb-6">
                        <p class="text-xs sm:text-sm text-[#6B7280]">
                            {{ now()->format('l, M d, Y') }}
                        </p>
                        <h1 class="text-xl sm:text-2xl font-semibold mt-1">
                            @yield('page-title', 'Good morning, Captain!')
                        </h1>
                    </div>

                    @yield('content')

                </div>
            </main>
        </div>
    </div>
</body>

</html>